﻿using System;
using System.ComponentModel.Composition;
using VRM.Integration.FTP.MVI.Messages;
using VRM.Integration.Servicebus.Core;
using VRM.Integration.Servicebus.Logging.CRM.Util;
using VRM.Integration.FTP.MVI.Processors;

namespace VRM.Integration.FTP.MVI.MessageHandler
{

     [Export(typeof (IMessageHandler))]
     [ExportMetadata("MessageType", MessageRegistry.FTPSelectedPersonRequest)]
    public class FTPSelectedPersonMessageHandler : RequestResponseHandler
    {
         /// <summary>
         /// 
         /// </summary>
         /// <param name="message"></param>
         /// <returns></returns>
        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                LogMessageReceipt(message);

                var processor = new FTPSelectedPersonProcessor();

                return processor.Execute((FTPSelectedPersonRequest)message);
            }
            catch (Exception ex)
            {
                FTPSelectedPersonRequest msg = (FTPSelectedPersonRequest)message;
                LogHelper.LogError(msg.OrganizationName,msg.UserId, "UDOSelectedPersonMessageHandler.HandleRequestResponse", ex);
                throw new Exception(string.Format("UDOSelectedPersonMessageHandler Error: {0}", ex.Message), ex);
            }
        }
      
    }
}
